#include <p30fxxxx.h>
#include <outcompare.h>

/* These devices support OutputCompare 3 and OutputCompare 4 */
#if defined (__dsPIC30F3011__) || defined (__dsPIC30F4011__) || defined (__dsPIC30F6010__) || \
    defined (__dsPIC30F5011__) || defined (__dsPIC30F6011__) || defined (__dsPIC30F6012__) || \
    defined (__dsPIC30F5013__) || defined (__dsPIC30F6013__) || defined (__dsPIC30F6014__) || \
    defined (__dsPIC30F4013__) || defined (__dsPIC30F5015__)

/********************************************************************
*    Function Name:  SetDCOC4PWM                                    *
*    Description:    This routine writes the duty cycle OCRS reg    *
*    Parameters:     unsigned int duty cycle                        *
*    Return Value:   None                                           *
********************************************************************/

void  SetDCOC4PWM(unsigned int dutycycle)
{   
    
    /* check OC is in PWM Mode.*/
    if((OC4CONbits.OCM & 0x06) == 0x06) 
       OC4RS = dutycycle; /* assign to OCRS */
}

#endif
